@ECHO OFF
REM Set PostgreSQL bin directory in PATH
set PATH=C:\Program Files\PostgreSQL\17\bin;%PATH%

set /p BackFileName="Enter File Name: "
set PGPASSWORD=sac

echo Dropping sac database if it exists...
dropdb --host=127.0.0.1 --port=5432 --username=postgres --no-password --if-exists sac
echo sac database dropped.

echo Creating sac database...
createdb --host=127.0.0.1 --port=5432 --username=postgres --no-password sac
echo sac database created.

cd ../DBBackups/toolbackups

echo Listing backup file contents...
pg_restore -l "%BackFileName%"

echo Starting Restore...
pg_restore --clean --dbname=postgresql://postgres:sac@127.0.0.1:5432/sac --format=custom --no-owner "%BackFileName%"

set /p DUMMY="Restore process completed. Press ENTER to close..."
